//Main

RequireScript("menu.js");
RequireScript("effect.js");
RequireScript("cinemathica.js");

//Record mode thingy
var counter = 0;
var FPS = 60;

//GAME SOUNDS
var sounds = new Object();

sounds["jump"] = LoadSound("jump.ogg");
sounds["pogo"] = LoadSound("jump.ogg");
sounds["Hillville"] = LoadSound("music/hillville.it");
sounds["Wonderment"] = LoadSound("music/wonderment.ogg");


//OTHER RESOURCES
var font = GetSystemFont();


function game()
{
	SetFrameRate(FPS);
	sounds["Wonderment"].play(true);
	
	////////////
	//  Menu  //
	////////////
	var mainmenupic = LoadImage("mainmenu.png");
	var darkgreen = CreateColor(0, 80, 0);
	var green = CreateColor(30, 120, 30);
	var mainmenu = new Menu(["Start tech demo", "Quit"], 4, 60);
	mainmenu.windowStyle = undefined;
	mainmenu.preRender = function()
	{	GradientRectangle(0, 0, GetScreenWidth(), GetScreenHeight(), darkgreen, green, darkgreen, green);
		mainmenupic.blit(0, 0);
		font.drawTextBox(4, 4, 160, 50, 0, "Project Keen\nversion 2008/07/01");
	}
	mainmenu.execute();
	if (mainmenu.cancelled || mainmenu.selectedCell == 1) Exit();
	
	
	////////////
	// Start! //
	////////////
	CreatePerson("Keen", "keen.rss", false);
	AttachCamera("Keen");
	
	var fo = new IntegerEffect("fade out", 60, 255);
	fo.init();
	var fi = new IntegerEffect("fade in", 60, 255);
	fi.init();
	
	sounds["Hillville"].play(true);
	sounds["Hillville"].setVolume(0);
	
	//Effect lasts for 1.5 second, fade in of song 2 starts halfway fade out of song 1.
	for (var i = 0; i < 90; i++)
	{
		if (i < 60) sounds["Wonderment"].setVolume(fo.update());
		if (i > 30) sounds["Hillville"].setVolume(fi.update());
		FlipScreen();
	}
	
	sounds["Wonderment"].stop();
	
	SetRenderScript("GameUpdate()");
	MapEngine("Forest1.rmp", 60);
}



var JumpStrength = 0.1;
var jumpstat = 0;
var jumping = false;
var fallanim = true;
var waitAnimCounter = 0;

var JumpHold = 0;
var JumpMax = 5;
var JumpHoldAllow = true;
var extraJump = 0;

var dir = "east";
var xspeed = 1;
var downpressed = false;

var pogo = false;
var pogowait = 0;

function GameUpdate()
{
	//RECORD
	//Uncomment this to record the game in png files.
	//Record();

	Camera.UpdateAndDraw();
	
	//COLLISION
	if (IsPersonObstructed("Keen", GetPersonX("Keen"), GetPersonY("Keen") + 1))
	{
		extraJump = 0;
		jumping = false;
		jumpstat = 0;
		
		while (IsPersonObstructed("Keen", GetPersonX("Keen"), GetPersonY("Keen") - 1))
			SetPersonY("Keen", GetPersonY("Keen") - 1);
	}
	
	if (!IsPersonObstructed("Keen", GetPersonX("Keen"), GetPersonY("Keen")) && !jumping)
	{
		//If he's falling but the next floor is just a bit below him... (for slopes)
		if (IsPersonObstructed("Keen", GetPersonX("Keen"), GetPersonY("Keen") + 5))
			SetPersonY("Keen", GetPersonY("Keen") + 1);
		
		//However, if there's more to it than just a slope, do make him fall.
		else
			jumping = true;
	}
	
	//Horizontal collision
	if (IsPersonObstructed("Keen", GetPersonX("Keen"), GetPersonY("Keen")-4))
		SetPersonX("Keen", GetPersonX("Keen") - xspeed);
	
	if (IsPersonObstructed("Keen", GetPersonX("Keen")+2, GetPersonY("Keen")-4) ||
			IsPersonObstructed("Keen", GetPersonX("Keen")-2, GetPersonY("Keen")-4))
		SetPersonDirection("Keen", "stopped_" + dir);
	
	
	//Vertical collision
	if (IsPersonObstructed("Keen", GetPersonX("Keen"), GetPersonY("Keen")-10))
		jumpstat += 1;
	
	
	//KEYS
	if (IsAnyKeyPressed()) waitAnimCounter = 0;
	if (IsKeyPressed(KEY_ESCAPE)) Exit();
	
	if (IsKeyPressed(KEY_LEFT) && !IsPersonObstructed("Keen", GetPersonX("Keen")-xspeed, GetPersonY("Keen")-4)){
		SetPersonX("Keen", GetPersonX("Keen") - xspeed);
		SetPersonDirection("Keen", "west");
		QueuePersonCommand("Keen", COMMAND_ANIMATE, true);
		dir = "west";
		if (downpressed){	downpressed = false; PanCamToPerson("Keen", 4,4, true);	}
	}
	
	else if (IsKeyPressed(KEY_RIGHT) && !IsPersonObstructed("Keen", GetPersonX("Keen")+xspeed, GetPersonY("Keen")-4)){
		SetPersonX("Keen", GetPersonX("Keen") + xspeed);
		SetPersonDirection("Keen", "east");
		QueuePersonCommand("Keen", COMMAND_ANIMATE, true);
		dir = "east";
		if (downpressed){	downpressed = false; PanCamToPerson("Keen", 4,4, true);	}
	}
	
	else if (IsKeyPressed(KEY_UP)){
		SetPersonDirection("Keen", "north");

		if (!downpressed)
			downpressed = true,
			SetPersonFrame("Keen", 0);

		PanCamXY( GetPersonX("Keen"), GetPersonY("Keen") - 64, 2,2);
	}
	
	else if (IsKeyPressed(KEY_DOWN))
	{
		SetPersonDirection("Keen", "south");
		
		if (!downpressed)
			downpressed = true,
			SetPersonFrame("Keen", 0);
		
		if (GetPersonFrame("Keen") < 2){
			QueuePersonCommand("Keen", COMMAND_ANIMATE, true);
			PanCamXY( GetPersonX("Keen"), GetPersonY("Keen") + 64*GetPersonFrame("Keen"), 2,2);
		}
	}
	else if (!IsKeyPressed(KEY_DOWN)){
	if (downpressed){	downpressed = false; PanCamToPerson("Keen", 4,4, true);	}
	}
	
	
	//Toggle speed between 1 and 2 to get a speed of 1.5!
	if (xspeed == 2) xspeed = 1;
	else if (xspeed == 1) xspeed = 2;
	
	//JUMP
	//At start...
	if (IsKeyPressed(KEY_CTRL) && !jumping && !pogo)
		sounds["jump"].play(false),
		jumping = true,
		fallanim = true,
		jumpstat = -1.5;
	
	//Takes care of the extra jump strength when holding the jump key.
	if (IsKeyPressed(KEY_CTRL) && jumping && extraJump < 10 && jumpstat < -1)
	{
		jumpstat-=0.25;
		extraJump++;
		if (pogo) extraJump+=0.5;
	}
	
	
	//POGO
	if (IsKeyPressed(KEY_ALT) && !pogo && pogowait == 0)
		pogowait = 20,
		pogo = true;
	
	else if (IsKeyPressed(KEY_ALT) && pogo && pogowait == 0)
		pogowait = 20,
		pogo = false;
	
	if (pogowait > 0) pogowait--;
	
	if (pogo && IsPersonObstructed("Keen", GetPersonX("Keen"), GetPersonY("Keen")))
		jumpstat = -3,
		sounds["pogo"].play(false);
	
	if (pogo)
		SetPersonDirection("Keen", "pogo_" + dir),
		SetPersonY("Keen", GetPersonY("Keen") + jumpstat),
		jumpstat+=JumpStrength;
	
	
	GetSystemFont().drawText(0, 0, "jumping: " + jumping);
	GetSystemFont().drawText(0, 10, "pogo: " + pogo);
	GetSystemFont().drawText(0, 20, "downpressed: " + downpressed);
	
	
	//GRAVITY
	if (jumping && !pogo)
		SetPersonY("Keen", GetPersonY("Keen") + jumpstat),
		jumpstat+=JumpStrength;
	
	
	//Jump/fall animation
	if (jumpstat < -0.5 && !pogo)
		SetPersonDirection("Keen", "jumping_" + dir),
		QueuePersonCommand("Keen", COMMAND_ANIMATE, true);
	
	if (jumpstat > 0.5 && fallanim && !pogo)
		SetPersonDirection("Keen", "falling_" + dir),
		QueuePersonCommand("Keen", COMMAND_ANIMATE, true);
	
	
	if (jumpstat > -0.5 && jumpstat < 0.5 && jumping && fallanim && !pogo)
		SetPersonDirection("Keen", "midair_" + dir),
		QueuePersonCommand("Keen", COMMAND_ANIMATE, true);
	
	
	//GetSystemFont().drawText(10, 10, waitAnimCounter);
	//STOPPED ANIMATION
	if (!jumping && !IsAnyKeyPressed())
	{
		waitAnimCounter++;
		
		//And now for the animations when waiting too long!
		if (waitAnimCounter < 120) SetPersonDirection("Keen", "stopped_" + dir);
		else if (waitAnimCounter == 120) SetPersonDirection("Keen", "north");
		else if (waitAnimCounter == 200) SetPersonDirection("Keen", "stopped_" + dir);
		else if (waitAnimCounter == 400) SetPersonDirection("Keen", "wait1");
		
		
		if (waitAnimCounter >= 400 /*&& waitAnimCounter < 500*/) QueuePersonCommand("Keen", COMMAND_ANIMATE, true);
	}
}



var add = "";
function Record()
{
	add = "";
	if (counter < 10) add += "0";
	if (counter < 100) add += "0";
	if (counter < 1000) add += "0";
	
	GrabSurface(0,0,GetScreenWidth(),GetScreenHeight()).save("a/" + add + counter + ".png");
	counter++;
}
